﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>
<%@ Import Namespace="System.Collections.Generic" %>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>

    <title>Zestawienie zbiorcze VAT</title>


    <style type="text/css">
        .xRazem {
            font-weight: bold;
        }
    </style>


    <script runat="server">

        //
        // ReSharper disable UseStringInterpolation
        // ReSharper disable MergeConditionalExpression 
        // ReSharper disable ConvertPropertyToExpressionBody
        // ReSharper disable InconsistentNaming
        //

        private static readonly bool AgregacjaWgOddzialuSlownikowego = true;
        private static bool _wielooddzialowosc;


        private void Grid1_BeforeRow(object sender, RowEventArgs args)
        {
            Grid1.ColumnTextCssClass = args.Row is RazemOddzialu ? "xRazem" : null;
        }


        private void Grid1_ItemsGet(object sender, ItemsGetEventArgs args)
        {
            if (args.Deep != 1)
                return;

            var razem = (RazemOddzialu)args.Row;

            if(_wielooddzialowosc)
                args.Enumerable = new ArrayList
                {
                    razem,
                    razem.RazemSrodkiTrwale,
                    razem.SrodkiTrwaleVATRok,
                    razem.SrodkiTrwaleTrasport,
                    razem.Nieruchomosci,
                    razem.Pozostale
                };
            else
                args.Enumerable = new ArrayList
                {
                    razem.RazemSrodkiTrwale,
                    razem.SrodkiTrwaleVATRok,
                    razem.SrodkiTrwaleTrasport,
                    razem.Nieruchomosci,
                    razem.Pozostale,
                    razem
                };
        }


        public class NettoVATBrutto
        {
            private Currency netto;
            private Currency vat;

            public static NettoVATBrutto Zero = new NettoVATBrutto(0, 0);


            internal NettoVATBrutto(Currency netto, Currency vat)
            {
                this.netto = netto;
                this.vat = vat;
            }


            internal NettoVATBrutto(Soneta.EwidencjaVat.NettoVATBrutto nvb)
            {
                netto = nvb.Netto;
                vat = nvb.VAT;
            }


            internal void Add(Currency pNetto, Currency pVat)
            {
                netto += pNetto;
                vat += pVat;
            }


            internal void Add(Soneta.EwidencjaVat.NettoVATBrutto nvb)
            {
                netto += nvb.Netto;
                vat += nvb.VAT;
            }


            internal void Add(NettoVATBrutto nvb)
            {
                netto += nvb.Netto;
                vat += nvb.VAT;
            }


            public Currency Netto { get { return netto; } }
            public Currency VAT { get { return vat; } }
        }


        public class RazemOddzialu : Odliczenia
        {
            private readonly OddzialFirmy oddzial;


            public RazemOddzialu(OddzialFirmy oddzial) :
                base(GetOddzialStr(oddzial))
            {
                this.oddzial = oddzial;
            }


            public RazemOddzialu() :
                base("RAZEM")
            {
                oddzial = null;
            }


            private static string GetOddzialStr(OddzialFirmy oddzial)
            {
                return _wielooddzialowosc ? (oddzial != null ? string.Format("{0}-{1}", oddzial.Symbol, oddzial.NazwaSkrocona) : "(bez oddziału)") : "RAZEM";
            }


            public OddzialFirmy Oddzial
            {
                get { return oddzial; }
            }


            public void Add(RazemOddzialu op)
            {
                base.Add(op);

                srodkiTrwaleVatRok.Add(op.srodkiTrwaleVatRok);
                srodkiTrwaleTrasport.Add(op.srodkiTrwaleTrasport);
                nieruchomosci.Add(op.nieruchomosci);
                razemSrodkiTrwale.Add(op.razemSrodkiTrwale);
                pozostale.Add(op.pozostale);
            }


            public void Update()
            {
                razemSrodkiTrwale.Tak.Add(srodkiTrwaleVatRok.Tak.Netto + srodkiTrwaleTrasport.Tak.Netto + nieruchomosci.Tak.Netto, srodkiTrwaleVatRok.Tak.VAT + srodkiTrwaleTrasport.Tak.VAT + nieruchomosci.Tak.VAT);
                razemSrodkiTrwale.Nie.Add(srodkiTrwaleVatRok.Nie.Netto + srodkiTrwaleTrasport.Nie.Netto + nieruchomosci.Nie.Netto, srodkiTrwaleVatRok.Nie.VAT + srodkiTrwaleTrasport.Nie.VAT + nieruchomosci.Nie.VAT);
                razemSrodkiTrwale.TakWarunkowo.Add(srodkiTrwaleVatRok.TakWarunkowo.Netto + srodkiTrwaleTrasport.TakWarunkowo.Netto + nieruchomosci.TakWarunkowo.Netto, srodkiTrwaleVatRok.TakWarunkowo.VAT + srodkiTrwaleTrasport.TakWarunkowo.VAT + nieruchomosci.TakWarunkowo.VAT);
                razemSrodkiTrwale.MieszanyTak.Add(srodkiTrwaleVatRok.MieszanyTak.Netto + srodkiTrwaleTrasport.MieszanyTak.Netto + nieruchomosci.MieszanyTak.Netto, srodkiTrwaleVatRok.MieszanyTak.VAT + srodkiTrwaleTrasport.MieszanyTak.VAT + nieruchomosci.MieszanyTak.VAT);
                razemSrodkiTrwale.MieszanyNie.Add(srodkiTrwaleVatRok.MieszanyNie.Netto + srodkiTrwaleTrasport.MieszanyNie.Netto + nieruchomosci.MieszanyNie.Netto, srodkiTrwaleVatRok.MieszanyNie.VAT + srodkiTrwaleTrasport.MieszanyNie.VAT + nieruchomosci.MieszanyNie.VAT);
                razemSrodkiTrwale.MieszanyWarunkowo.Add(srodkiTrwaleVatRok.MieszanyWarunkowo.Netto + srodkiTrwaleTrasport.MieszanyWarunkowo.Netto + nieruchomosci.MieszanyWarunkowo.Netto, srodkiTrwaleVatRok.MieszanyWarunkowo.VAT + srodkiTrwaleTrasport.MieszanyWarunkowo.VAT + nieruchomosci.MieszanyWarunkowo.VAT);
                razemSrodkiTrwale.Lacznie.Add(srodkiTrwaleVatRok.Lacznie.Netto + srodkiTrwaleTrasport.Lacznie.Netto + nieruchomosci.Lacznie.Netto, srodkiTrwaleVatRok.Lacznie.VAT + srodkiTrwaleTrasport.Lacznie.VAT + nieruchomosci.Lacznie.VAT);

                Tak.Add(razemSrodkiTrwale.Tak.Netto + pozostale.Tak.Netto, razemSrodkiTrwale.Tak.VAT + pozostale.Tak.VAT);
                Nie.Add(razemSrodkiTrwale.Nie.Netto + pozostale.Nie.Netto, razemSrodkiTrwale.Nie.VAT + pozostale.Nie.VAT);
                TakWarunkowo.Add(razemSrodkiTrwale.TakWarunkowo.Netto + pozostale.TakWarunkowo.Netto, razemSrodkiTrwale.TakWarunkowo.VAT + pozostale.TakWarunkowo.VAT);
                MieszanyTak.Add(razemSrodkiTrwale.MieszanyTak.Netto + pozostale.MieszanyTak.Netto, razemSrodkiTrwale.MieszanyTak.VAT + pozostale.MieszanyTak.VAT);
                MieszanyNie.Add(razemSrodkiTrwale.MieszanyNie.Netto + pozostale.MieszanyNie.Netto, razemSrodkiTrwale.MieszanyNie.VAT + pozostale.MieszanyNie.VAT);
                MieszanyWarunkowo.Add(razemSrodkiTrwale.MieszanyWarunkowo.Netto + pozostale.MieszanyWarunkowo.Netto, razemSrodkiTrwale.MieszanyWarunkowo.VAT + pozostale.MieszanyWarunkowo.VAT);
                Lacznie.Add(razemSrodkiTrwale.Lacznie.Netto + pozostale.Lacznie.Netto, razemSrodkiTrwale.Lacznie.VAT + pozostale.Lacznie.VAT);
            }

            private readonly Odliczenia srodkiTrwaleVatRok = new Odliczenia("Środki trwałe VAT rok");
            private readonly Odliczenia srodkiTrwaleTrasport = new Odliczenia("Środki trwałe + transport");
            private readonly Odliczenia nieruchomosci = new Odliczenia("Nieruchomości");
            private readonly Odliczenia pozostale = new Odliczenia("Pozostałe");
            private readonly Odliczenia razemSrodkiTrwale = new Odliczenia("Razem środki trwałe");


            public Odliczenia SrodkiTrwaleVATRok
            { get { return srodkiTrwaleVatRok; } }

            public Odliczenia SrodkiTrwaleTrasport
            { get { return srodkiTrwaleTrasport; } }

            public Odliczenia Nieruchomosci
            { get { return nieruchomosci; } }

            public Odliczenia Pozostale
            { get { return pozostale; } }

            public Odliczenia RazemSrodkiTrwale
            { get { return razemSrodkiTrwale; } }
        }


        public class Odliczenia
        {
            private readonly NettoVATBrutto tak = new NettoVATBrutto(0, 0);
            private readonly NettoVATBrutto nie = new NettoVATBrutto(0, 0);
            private readonly NettoVATBrutto takWarunkowo = new NettoVATBrutto(0, 0);
            private readonly NettoVATBrutto mieszanyTak = new NettoVATBrutto(0, 0);
            private readonly NettoVATBrutto mieszanyNie = new NettoVATBrutto(0, 0);
            private readonly NettoVATBrutto mieszanyWarunkowo = new NettoVATBrutto(0, 0);
            private readonly NettoVATBrutto lacznie = new NettoVATBrutto(0, 0);


            public Odliczenia(string rodzaj)
            {
                Rodzaj = rodzaj;
            }


            public string Rodzaj { get; private set; }


            public NettoVATBrutto Tak
            { get { return tak; } }

            public NettoVATBrutto Nie
            { get { return nie; } }

            public NettoVATBrutto TakWarunkowo
            { get { return takWarunkowo; } }

            public NettoVATBrutto MieszanyTak
            { get { return mieszanyTak; } }

            public NettoVATBrutto MieszanyNie
            { get { return mieszanyNie; } }

            public NettoVATBrutto MieszanyWarunkowo
            { get { return mieszanyWarunkowo; } }

            public NettoVATBrutto Lacznie
            { get { return lacznie; } }



            public void Add(Odliczenia op)
            {
                tak.Add(op.tak);
                nie.Add(op.nie);
                takWarunkowo.Add(op.takWarunkowo);
                mieszanyTak.Add(op.mieszanyTak);
                mieszanyNie.Add(op.mieszanyNie);
                mieszanyWarunkowo.Add(op.mieszanyWarunkowo);
                lacznie.Add(op.lacznie);
            }
        }


        private static Date GetDataDoWsp(INaglowekVAT nag)
        {
            var nagEwid = nag as NagEwidencjiVAT;
            return nagEwid != null ? nagEwid.DataZaewidencjonowania : ((NagRozliczeniaVAT)nag).Data;
        }


        private void EwidencjaVAT_OnLoad(object sender, EventArgs args)
        {
            _wielooddzialowosc = DataContext1.Session.Get<CoreModule>().Config.Ogólne.Wielooddziałowość;

            var service = (IWspolczynnikVATService)DataContext1.Session.GetService(typeof(IWspolczynnikVATService));
            var p = (NagEwidencjiVATT.ParamsEx)DataContext1.Get(typeof(NagEwidencjiVATT.ParamsEx));
            var rozliczenia = p is NagRozliczenVATT.ParamsEx;

            var prewsp = 1m;
            var wsp = 1m;
            var wspNie = 1m;

            var wgOddzialu = new SortedDictionary<string, RazemOddzialu>();
            if (p.Typ == TypEwidencjiVAT.Zakup)
            {
                foreach (INaglowekVAT nag in (Row[])DataContext1.Get(typeof(Row[])))
                {
                    var odd = _wielooddzialowosc ? nag.Ewidencja.Oddzial : null;
                    if (odd != null && AgregacjaWgOddzialuSlownikowego)
                        odd = odd.GetOddzialTypu(OddzialParamsType.Słownikowe, true);
                    var symbolOdd = odd == null ? string.Empty : odd.Symbol;

                    RazemOddzialu odliczenia;
                    if (wgOddzialu.ContainsKey(symbolOdd))
                        odliczenia = wgOddzialu[symbolOdd];
                    else
                    {
                        odliczenia = new RazemOddzialu(odd);
                        wgOddzialu.Add(symbolOdd, odliczenia);
                    }

                    if (Prms.Wart == Wartosci.WgWspółczynników)
                    {
                        var wspArgs = new WspolczynnikVATServiceArgs
                        {
                            Data = GetDataDoWsp(nag),
                            Oddział = nag.Ewidencja.Oddzial,
                            Oddzialowosc = WspolczynnikVATServiceOddzialowosc.WgOddzialuDeklVAT
                        };

                        prewsp = service.CalcPrewspolczynnik( wspArgs);
                        wsp = service.CalcWspolczynnik( wspArgs);
                    }

                    foreach (var elem in nag.GetElementy())
                    {
                        Odliczenia rodzaj;
                        switch (elem.Rodzaj)
                        {
                            case RodzajZakupuVAT.ŚrodkiTrwałeVATRocznie:
                                rodzaj = odliczenia.SrodkiTrwaleVATRok;
                                break;
                            case RodzajZakupuVAT.ŚrodkiTrwałe:
                            case RodzajZakupuVAT.ŚrodkiTransportu:
                                rodzaj = odliczenia.SrodkiTrwaleTrasport;
                                break;
                            case RodzajZakupuVAT.Nieruchomości:
                                rodzaj = odliczenia.Nieruchomosci;
                                break;
                            default:
                                rodzaj = odliczenia.Pozostale;
                                break;
                        }

                        if (elem.DzialalnoscGosp == DzialalnoscGospodarcza.Tak && elem.Odliczenia == OdliczeniaVAT.Tak)
                        {
                            rodzaj.Tak.Add(elem.Netto, elem.VAT);
                            rodzaj.Lacznie.Add(elem.Netto, elem.VAT);
                        }

                        else if (elem.DzialalnoscGosp == DzialalnoscGospodarcza.Tak && elem.Odliczenia == OdliczeniaVAT.Warunkowo)
                        {
                            var nvb = CalcNvb(elem, 1, wsp);
                            rodzaj.TakWarunkowo.Add(nvb);
                            rodzaj.Lacznie.Add(nvb);
                        }

                        else if (elem.DzialalnoscGosp == DzialalnoscGospodarcza.CelMieszany && elem.Odliczenia == OdliczeniaVAT.Tak)
                        {
                            var nvb = CalcNvb(elem, prewsp, 1);
                            rodzaj.MieszanyTak.Add(nvb);
                            rodzaj.Lacznie.Add(nvb);
                        }

                        else if (elem.DzialalnoscGosp == DzialalnoscGospodarcza.CelMieszany && elem.Odliczenia == OdliczeniaVAT.Nie)
                        {
                            var nvb = CalcNvb(elem, prewsp, wspNie);
                            rodzaj.MieszanyNie.Add(nvb);
                        }

                        else if (elem.DzialalnoscGosp == DzialalnoscGospodarcza.CelMieszany && elem.Odliczenia == OdliczeniaVAT.Warunkowo)
                        {
                            var nvb = CalcNvb(elem, prewsp, wsp);
                            rodzaj.MieszanyWarunkowo.Add(nvb);
                            rodzaj.Lacznie.Add(nvb);
                        }

                        else
                        {
                            rodzaj.Nie.Add(elem.Netto, elem.VAT);
                        }
                    }
                }
            }

            //
            // PODSUMOWANIE ODDZIAŁÓW
            //

            if (_wielooddzialowosc)
            {
                var oddzialSumaryczny = new RazemOddzialu();
                foreach (var o in wgOddzialu.Values)
                {
                    o.Update();
                    oddzialSumaryczny.Add(o);
                }

                Grid1.DataSource = new List<RazemOddzialu>(wgOddzialu.Values) { oddzialSumaryczny };
            }
            else
            {
                foreach (var o in wgOddzialu.Values)
                    o.Update();

                Grid1.DataSource = new List<RazemOddzialu>(wgOddzialu.Values);
            }

            //
            // NAGŁOWEK WYDRUKU
            //

            var tytul = string.Format("Zestawienie zbiorcze {0} VAT - wartości {1}", rozliczenia ? "rozliczeń" : "ewidencji", CaptionAttribute.EnumToString(Prms.Wart).ToLower());
            var tytulNaglowka = string.Format("{0} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3}, Podmiot: {4}, Korekty: {5} |Działalność: {9}, Odliczenia: {10}|Rodzaj: {6}, Rodzaj pod.: {7}, Status pod.: {8}",
                                tytul, p.Typ, p.Zakres, p.Definicja == null ? "Wszystkie" : p.Definicja.ToString(), p.Podmiot == null ? "Wszyscy" : p.Podmiot.ToString(), p.Korekty, p.RodzajZakupu, p.RodzajPodmiotu, p.StatusPodmiotu,
                                CaptionAttribute.EnumToString(p.DzialalnoscGospodarcza), CaptionAttribute.EnumToString(p.Odliczenia));

            if (p.Porownanie != TypPorownania.Brak)
                tytulNaglowka = string.Format("{0} | Kwota brutto {1} {2:n}", tytulNaglowka, CaptionAttribute.EnumToString(p.Porownanie), p.Kwota);

            ReportHeader1.Title = tytulNaglowka;
        }


        private static NettoVATBrutto CalcNvb(IElementVAT elem, decimal prewsp, decimal wsp)
        {
            return new NettoVATBrutto
                (
                    Soneta.Tools.Math.RoundCy(Soneta.Tools.Math.RoundCy(elem.Netto.Value * prewsp) * wsp),
                    Soneta.Tools.Math.RoundCy(Soneta.Tools.Math.RoundCy(elem.VAT.Value * prewsp) * wsp)
                );
        }


        public enum Wartosci
        {
            Nominalne,
            WgWspółczynników
        }


        public class Parameters : ContextBase
        {
            [Caption("Wartości")]
            [DefaultWidth(16)]
            public Wartosci Wart { get; set; }


            public Parameters(Context context) : base(context)
            { }
        }


        [Context]
        public Parameters Prms { get; set; }


    </script>
</head>

<body>
    <form id="ZestawinieZbiorczeVAT" method="post" runat="server" onload="EwidencjaVAT_OnLoad">
        <ea:DataContext ID="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business" Landscape="true"></ea:DataContext>
        <cc1:ReportHeader ID="ReportHeader1" runat="server" Title="{0} | Za okres: {1}"></cc1:ReportHeader>
        <ea:Grid ID="Grid1" runat="server" ShowSum="Never" OnBeforeRow="Grid1_BeforeRow" OnItemsGet="Grid1_ItemsGet" RowTypeName="Odliczenia">
            <Columns>
                <ea:GridColumn runat="server" Align="Left" Width="22" Total="Info" DataMember="Rodzaj" Caption="Oddział/Rodzaj"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="Nie.Netto.Value" Caption="Nie (1)~Netto" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="Nie.VAT.Value" Caption="Nie (1)~VAT" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="Tak.Netto.Value" Caption="Tak (2)~Netto" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="Tak.VAT.Value" Caption="Tak (2)~VAT" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="TakWarunkowo.Netto.Value" Caption="Tak/Warunkowo (3)~Netto" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="TakWarunkowo.VAT.Value" Caption="Tak/Warunkowo (3)~VAT" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="MieszanyTak.Netto.Value" Caption="Cel mieszany/Tak (4)~Netto" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="MieszanyTak.VAT.Value" Caption="Cel mieszany/Tak (4)~VAT" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="MieszanyNie.Netto.Value" Caption="Cel mieszany/Nie (5)~Netto" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="MieszanyNie.VAT.Value" Caption="Cel mieszany/Nie (5)~VAT" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="MieszanyWarunkowo.Netto.Value" Caption="Cel mieszany/Warunkowo (6)~Netto" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="MieszanyWarunkowo.VAT.Value" Caption="Cel mieszany/Warunkowo (6)~VAT" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="Lacznie.Netto.Value" Caption="Łącznie (2+3+4+6)~Netto" Format="{0:n}"></ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Total="Sum" DataMember="Lacznie.VAT.Value" Caption="Łącznie (2+3+4+6)~VAT" Format="{0:n}"></ea:GridColumn>
            </Columns>
        </ea:Grid>
        <br>
        <cc1:ReportFooter ID="ReportFooter1" runat="server"></cc1:ReportFooter>
    </form>
</body>
</html>
